package com.javaDevHome.ladyBeetle.test;

import java.io.FileInputStream;

import org.dbunit.DBTestCase;
import org.dbunit.PropertiesBasedJdbcDatabaseTester;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;

import com.javaDevHome.ladyBeetle.IMicroJDBCConnection;
import com.javaDevHome.ladyBeetle.MicroJDBCConnection;
import com.javaDevHome.ladyBeetle.MicroJDBCDBase;
import com.javaDevHome.ladyBeetle.MicroJDBCRecord;
import com.javaDevHome.ladyBeetle.exception.MicroJDBCException;

public class LadyBeetleTest extends DBTestCase {

	private String jdbcDriver = "oracle.jdbc.driver.OracleDriver";
//	private String jdbcURL = "jdbc:oracle:thin:@localhost:1521:TEST";
	private String jdbcURL = "myDBTry";
	private String jdbcUserName = "myUserName";
	private String jdbcPassword = "myPassword";
	private MicroJDBCDBase mdb;

	public LadyBeetleTest(String name) {
		super(name);
		System.setProperty(
				PropertiesBasedJdbcDatabaseTester.DBUNIT_DRIVER_CLASS,
				jdbcDriver);
		System.setProperty(
				PropertiesBasedJdbcDatabaseTester.DBUNIT_CONNECTION_URL,
				jdbcURL);
		System.setProperty(PropertiesBasedJdbcDatabaseTester.DBUNIT_USERNAME,
				jdbcUserName);
		System.setProperty(PropertiesBasedJdbcDatabaseTester.DBUNIT_PASSWORD,
				jdbcPassword);
//		System.setProperty(PropertiesBasedJdbcDatabaseTester.DBUNIT_SCHEMA,
//				jdbcUserName);

	}

	protected IDataSet getDataSet() throws Exception {
        return new FlatXmlDataSet(new FileInputStream("C:/home/semih/workspace/europaFall2/ladyBeetle4Test/src/dataset/ladyBeetle01.xml"));
	}

	class EmployeeSelect extends MicroJDBCRecord{
		int id;
		String name;
		String lastName;

		public String getSelectSql() {
			return "SELECT id, name, lastname FROM myUserName.Employee WHERE id = " + id;
		}
		
		public void select(IMicroJDBCConnection rs) throws MicroJDBCException {
			name = rs.getString(2);
			lastName = rs.getString(3);
		}
	}
	
	public void test01(){
		mdb = new MicroJDBCDBase();
		EmployeeSelect employee = new EmployeeSelect();
		employee.id = 8;
		try {
			mdb.selectRow(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		assertEquals(employee.name, "hasan");
	}
}
