package com.javaDevHome.ladyBeetle.test;

import junit.framework.TestCase;

import com.javaDevHome.ladyBeetle.MicroJDBCDBase;
import com.javaDevHome.ladyBeetle.exception.MicroJDBCException;

public class LadyBeetleCrudTestPlain extends TestBasePlain {
	
	public LadyBeetleCrudTestPlain(){
		mdb = new MicroJDBCDBase();
		mdb.initConnection( jdbcDriver, jdbcURL, jdbcUserName, jdbcPassword);
//		mdb.initConnection( jdbcDriver, "myDBTry", jdbcUserName, jdbcPassword);
	}
	
	public void testAll(){
//		testUpdate(idJohn, "John");
//		testUpdate(idJane, "Jane");
//		testDelete(21);
//		testDelete(22);
//		testDelete(23);
		
		testCount(lineSize);
		testSelect01();
		testSelect02();
		testSelect03();
		testSelect04();
		testSelect(idJane, "Jane");
		testCannotSelect(45);
		testCannotSelect01();
		
		testCount(lineSize);
		testInsert01();
		testUpdate01();
		testDelete01();
		
		testCount(lineSize);
		testInsert02();
		testDelete02();
		
		testCount(lineSize);
		testInsert03();
		testUpdate03();
		testDelete03();
		
		testCount(lineSize);
		testCannotInsert01();

		testCount(lineSize);
		testInsert01();
		testCannotUpdate01();
		testDelete01();
		testCannotUpdate02();
		
		testCount(lineSize);
		testCannotDelete01();

		testCount(lineSize);
		testCannotDelete02();
		
		testCount(lineSize);
		testInsert01();
		testUpdateInsert01();
		testDelete01();
		
		testCount(lineSize);
		testCannotSelect(id2);
		testUpdateInsert02();
		testDelete02();
		
		testCount(lineSize);
		testInsert01();
		testCannotUpdateInsert01();
		testDelete01();
		
		testCount(lineSize);
		testCannotSelect(id2);
		testCannotUpdateInsert02();
		
		testCount(lineSize);
		
		logCon();
	}
	
	public void testCount(int size){
		Count count = new Count();
		try {
			mdb.selectRow(count);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		assertEquals(count.int1, size);
	}
	
	public void testSelect01(){
		Employee employee = new Employee();
		employee.id = idJohn;
		try {
			mdb.selectRow(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		assertEquals(employee.name, "John");
	}
	
	public void testSelect02(){
		Employee employee = new Employee();
		employee.id = idJane;
		try {
			mdb.selectRow(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		assertEquals(employee.name, "Jane");
	}
	
	public void testSelect03(){
		EmployeePrep employee = new EmployeePrep();
		employee.id = idJohn;
		try {
			mdb.selectRow(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		assertEquals(employee.name, "John");
	}
	
	public void testSelect04(){
		EmployeePrep employee = new EmployeePrep();
		employee.id = idJane;
		try {
			mdb.selectRow(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		assertEquals(employee.name, "Jane");
	}

	
	public void testSelect(int id, String name){
		EmployeePrep employee = new EmployeePrep();
		employee.id = id;
		try {
			mdb.selectRow(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		assertEquals(employee.name, name);
	}
	
	public void testCannotSelect(int id){
		EmployeePrep employee = new EmployeePrep();
		employee.id = id;
		try {
			mdb.selectRow(employee);
			assertTrue(false);
		} catch (MicroJDBCException e) {
			assertEquals(e.getMessage(), MicroJDBCDBase.RECORD_NOT_FOUND);
		}
	}
	
	public void testCannotSelect01(){
		EmployeeDefective employee = new EmployeeDefective();
		employee.id = idJane;
		try {
			mdb.selectRow(employee);
			assertTrue(false);
		} catch (MicroJDBCException e) {
			assertStartsWith(e.getMessage());
		}
	}
	
	public void testInsert01(){
		Employee employee = new Employee();
		employee.id = id1;
		employee.name = "fatma";
		employee.lastName = "girik";
		try {
			mdb.insert(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		testSelect(employee.id, employee.name);
	}
	
	public void testInsert02(){
		Employee employee = new Employee();
		employee.id = id2;
		employee.name = "fatma";
		employee.lastName = "girik";
		try {
			mdb.insert(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		testSelect(employee.id, employee.name);
	}
	
	public void testInsert03(){
		EmployeePrep employee = new EmployeePrep();
		employee.id = id3;
		employee.name = "fatma";
		employee.lastName = "girik";
		try {
			mdb.insert(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		testSelect(employee.id, employee.name);
	}
	
	public void testCannotInsert01(){
		EmployeeDefective employee = new EmployeeDefective();
		employee.id = id1;
		employee.name = "fatma";
		employee.lastName = "girik";
		try {
			mdb.insert(employee);
			assertTrue(false);
		} catch (MicroJDBCException e) {
//			assertTrue(e.getMessage().trim().startsWith("java.sql.SQLException: ORA-00917: missing comma"));
			assertStartsWith(e.getMessage());
		}
		testCannotSelect(employee.id);
	}
	
	public void testDelete01(){
		Employee employee = new Employee();
		employee.id = id1;
		try {
			mdb.delete(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		testCannotSelect(employee.id);
	}
	
	public void testDelete02(){
		Employee employee = new Employee();
		employee.id = id2;
		try {
			mdb.delete(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		testCannotSelect(employee.id);
	}
	
	public void testDelete03(){
		EmployeePrep employee = new EmployeePrep();
		employee.id = id3;
		try {
			mdb.delete(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		testCannotSelect(employee.id);
	}
	
	public void testDelete(int id){
		Employee employee = new Employee();
		employee.id = id;
		try {
			mdb.delete(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		testCannotSelect(employee.id);
	}
	
	public void testCannotDelete01(){
		Employee employee = new Employee();
		employee.id = idNotExist;
		try {
			mdb.delete(employee);
			assertTrue(false);
		} catch (MicroJDBCException e) {
			assertEquals(e.getMessage(), MicroJDBCDBase.RECORD_NOT_FOUND);
		}
		testCannotSelect(employee.id);
	}
	
	public void testCannotDelete02(){
		EmployeeDefective employee = new EmployeeDefective();
		employee.id = idJane;
		try {
			mdb.delete(employee);
			assertTrue(false);
		} catch (MicroJDBCException e) {
			assertStartsWith(e.getMessage());
		}
	}
	
	public void testUpdate01(){
		Employee employee = new Employee();
		employee.id = id1;
		employee.name = "turkan";
		employee.lastName = "soray";
		try {
			mdb.update(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		testSelect(employee.id, employee.name);
	}
	
	
	public void testUpdate03(){
		EmployeePrep employee = new EmployeePrep();
		employee.id = id3;
		employee.name = "zerrin";
		employee.lastName = "egeliler";
		try {
			mdb.update(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		testSelect(employee.id, employee.name);
	}
	
	
	public void testUpdate(int id, String name){
		Employee employee = new Employee();
		employee.id = id;
		try {
			mdb.selectRow(employee);
			employee.name = name;
			mdb.update(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		testSelect(employee.id, employee.name);
	}
	
	
	public void testCannotUpdate01(){
		EmployeeDefective employee = new EmployeeDefective();
		employee.id = id1;
		employee.name = "turkan";
		employee.lastName = "soray";
		try {
			mdb.update(employee);
			assertTrue(false);
		} catch (MicroJDBCException e) {
//			assertTrue(e.getMessage().trim().startsWith("java.sql.SQLException: ORA-00933: SQL command not properly ended"));
			assertStartsWith(e.getMessage());
		}
		testSelect(employee.id, "fatma");
	}
	
	public void testCannotUpdate02(){
		Employee employee = new Employee();
		employee.id = idNotExist;
		employee.name = "turkan";
		employee.lastName = "soray";
		try {
			mdb.update(employee);
			assertTrue(false);
		} catch (MicroJDBCException e) {
			assertEquals(e.getMessage(), MicroJDBCDBase.RECORD_NOT_FOUND);
		}
		testCannotSelect(employee.id);
	}
	
	public void testUpdateInsert01(){
		Employee employee = new Employee();
		employee.id = id1;
		employee.name = "turkan";
		employee.lastName = "soray";
		try {
			mdb.updateOrInsert(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		testSelect(employee.id, employee.name);
	}
	
	public void testUpdateInsert02(){
		Employee employee = new Employee();
		employee.id = id2;
		employee.name = "turkan";
		employee.lastName = "soray";
		try {
			mdb.updateOrInsert(employee);
		} catch (MicroJDBCException e) {
			e.printStackTrace();
		}
		testSelect(employee.id, employee.name);
	}
	
	public void testCannotUpdateInsert01(){
		EmployeeDefective employee = new EmployeeDefective();
		employee.id = id1;
		employee.name = "turkan";
		employee.lastName = "soray";
		try {
			mdb.updateOrInsert(employee);
			assertTrue(false);
		} catch (MicroJDBCException e) {
//			assertTrue(e.getMessage().trim().startsWith("java.sql.SQLException: ORA-00917: missing comma"));
			assertStartsWith(e.getMessage());
		}
		testSelect(employee.id, "fatma");
	}
	
	public void testCannotUpdateInsert02(){
		EmployeeDefective employee = new EmployeeDefective();
		employee.id = idNotExist;
		employee.name = "turkan";
		employee.lastName = "soray";
		try {
			mdb.updateOrInsert(employee);
			assertTrue(false);
		} catch (MicroJDBCException e) {
//			assertTrue(e.getMessage().trim().startsWith("java.sql.SQLException: ORA-00917: missing comma"));
			assertStartsWith(e.getMessage());
//			assertEquals(e.getMessage(), MicroJDBCDBase.RECORD_NOT_FOUND);
		}
		testCannotSelect(employee.id);
	}
	
	public void assertStartsWith(String str1){
		if (DB == DB_ORACLE){
			assertTrue(str1.trim().startsWith("java.sql.SQLException"));
		}else if (DB == DB_OFFICE){
//			assertTrue(str1.trim().startsWith("Exception in thread"));
		}
	}

	
	public static void main(String[] args) {
		LadyBeetleCrudTestPlain lbctp = new LadyBeetleCrudTestPlain();
		lbctp.testAll();
	}
	
	String wrongValue = "\t";
	
	int id1 = 21;
	int id2 = 22;
	int id3 = 23;
	int id4 = 24;
	int idJohn = 12;
	int idJane = 16;
	int idNotExist = 10001;
	
	final int lineSize = 2;
	
	int DB_ORACLE = 1;
	int DB_OFFICE = 2;
	int DB = DB_OFFICE;
}
