package com.javaDevHome.ladyBeetle.test;

import com.javaDevHome.ladyBeetle.MicroJDBCConnection;
import com.javaDevHome.ladyBeetle.MicroJDBCRecord;
import com.javaDevHome.ladyBeetle.exception.MicroJDBCException;

class EmployeePrep extends MicroJDBCRecord{
	int id;
	String name;
	String lastName;
	
	public EmployeePrep(){
		setSqlStatementType(2); // prepared statement
	}

	public String getSelectSql() {
		return "SELECT id, name, lastname FROM Employee WHERE id = ?";
	}
	
	public void prepareSelect(MicroJDBCConnection ps) throws MicroJDBCException {
		ps.setInt(1,id);
	}
	
	public void select(MicroJDBCConnection rs) throws MicroJDBCException {
		name = rs.getString(2);
		lastName = rs.getString(3);
	}

	public void prepareInsert(MicroJDBCConnection ps) throws MicroJDBCException {
		ps.setInt(1,id);
		ps.setString(2,name);
		ps.setString(3,lastName);
	}
	
	public String getInsertSql() {
		return "INSERT INTO Employee (id, name, lastName) VALUES (?,?,?)";
	}
	
	public void prepareUpdate(MicroJDBCConnection ps) throws MicroJDBCException {
		ps.setInt(3,id);
		ps.setString(1,name);
		ps.setString(2,lastName);
	}
	
	public String getUpdateSql() {
		return "UPDATE Employee set name=?, lastname=? WHERE id = ?";
	}

	public void prepareDelete(MicroJDBCConnection ps) throws MicroJDBCException {
		ps.setInt(1,id);
	}
	
	public String getDeleteSql() {
		return "DELETE FROM Employee WHERE id = ?";
	}
}

